/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot.internal.maven;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.thevpc.nuts.boot.NBootRepositoryLocation;
import net.thevpc.nuts.boot.internal.maven.NMavenSettingsBoot;
import net.thevpc.nuts.boot.internal.util.NBootContext;
import net.thevpc.nuts.boot.internal.util.NBootLog;
import net.thevpc.nuts.boot.internal.util.NBootMsg;
import net.thevpc.nuts.boot.internal.util.NBootUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NMavenSettingsLoaderBoot {
    private String settingsFilePath;

    public NBootLog getLog() {
        return NBootContext.log();
    }

    public String getSettingsFilePath() {
        return this.settingsFilePath;
    }

    public NMavenSettingsLoaderBoot setSettingsFilePath(String settingsFilePath) {
        this.settingsFilePath = settingsFilePath;
        return this;
    }

    private static Boolean elementBoolean(Node c, boolean def) {
        String t = NMavenSettingsLoaderBoot.elementText(c);
        if (t.isEmpty()) {
            return def;
        }
        return Boolean.parseBoolean(t);
    }

    private static String elementText(Node c) {
        String e;
        String string = e = c == null ? null : c.getTextContent();
        if (e == null) {
            e = "";
        }
        e = e.trim();
        return e;
    }

    private static List<Element> elementsByName(Node c, String name) {
        return NMavenSettingsLoaderBoot.elements(c, x -> NMavenSettingsLoaderBoot.nodeHasName(c, name));
    }

    private static List<Element> elements(Node c) {
        return NMavenSettingsLoaderBoot.elements(c, null);
    }

    private static Element element(Node c, Predicate<Element> cond) {
        List<Element> all = NMavenSettingsLoaderBoot.elements(c, cond);
        if (all.isEmpty()) {
            return null;
        }
        return all.get(0);
    }

    private static List<Element> elements(Node c, Predicate<Element> cond) {
        return NMavenSettingsLoaderBoot.nodes(c, x -> x instanceof Element && (cond == null || cond.test((Element)x)));
    }

    private static List<Node> nodes(Node c, Predicate<Node> cond) {
        ArrayList<Node> li = new ArrayList<Node>();
        NodeList a = c.getChildNodes();
        for (int i = 0; i < a.getLength(); ++i) {
            Node e = a.item(i);
            if (cond != null && !cond.test(e)) continue;
            li.add(e);
        }
        return li;
    }

    private static boolean nodeHasName(Node e, String name) {
        return Objects.equals(e.getNodeName(), name);
    }

    public NMavenSettingsBoot loadSettingsRepos() {
        Path path;
        String settingsFilePath = this.settingsFilePath;
        ArrayList<NBootRepositoryLocation> list = new ArrayList<NBootRepositoryLocation>();
        NMavenSettingsBoot settings = new NMavenSettingsBoot();
        if (NBootUtils.isBlank(settingsFilePath)) {
            settingsFilePath = System.getProperty("user.home") + NBootUtils.getNativePath("/.m2/settings.xml");
        }
        if (Files.isRegularFile(path = Paths.get(settingsFilePath, new String[0]), new LinkOption[0]) && Files.isReadable(path)) {
            try (InputStream xml = Files.newInputStream(path, new OpenOption[0]);){
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = null;
                doc = builder.parse(xml);
                Element c = doc.getDocumentElement();
                block17: for (Element e : NMavenSettingsLoaderBoot.elements(c)) {
                    switch (e.getNodeName()) {
                        case "localRepository": {
                            String url0 = NMavenSettingsLoaderBoot.elementText(e);
                            if (!NBootUtils.isBlank(url0)) {
                                settings.setLocalRepository(url0.trim());
                            }
                        }
                        case "mirrors": {
                            for (Element mirror : NMavenSettingsLoaderBoot.elements(e, x -> x.getNodeName().equals("mirror"))) {
                                String id = NMavenSettingsLoaderBoot.elementText(NMavenSettingsLoaderBoot.element(mirror, x -> x.getNodeName().equals("id")));
                                String url0 = NMavenSettingsLoaderBoot.elementText(NMavenSettingsLoaderBoot.element(mirror, x -> x.getNodeName().equals("url")));
                                if (NBootUtils.isBlank(id) || NBootUtils.isBlank(url0)) continue;
                                list.add(NBootRepositoryLocation.of(id.trim(), "maven", url0.trim()));
                            }
                            continue block17;
                        }
                        case "profiles": {
                            for (Element profile : NMavenSettingsLoaderBoot.elements(e, x -> x.getNodeName().equals("profile"))) {
                                boolean active = true;
                                for (Element activation : NMavenSettingsLoaderBoot.elements(profile, x -> x.getNodeName().equals("activation"))) {
                                    for (Element activeByDefault : NMavenSettingsLoaderBoot.elements(activation, x -> x.getNodeName().equals("activeByDefault"))) {
                                        active = NMavenSettingsLoaderBoot.elementBoolean(activeByDefault, active);
                                    }
                                }
                                if (!active) continue;
                                for (Element repositories : NMavenSettingsLoaderBoot.elements(profile, x -> x.getNodeName().equals("repositories"))) {
                                    for (Element repository : NMavenSettingsLoaderBoot.elements(repositories, x -> x.getNodeName().equals("repository"))) {
                                        String id = NMavenSettingsLoaderBoot.elementText(NMavenSettingsLoaderBoot.element(repository, x -> x.getNodeName().equals("id")));
                                        String url0 = NMavenSettingsLoaderBoot.elementText(NMavenSettingsLoaderBoot.element(repository, x -> x.getNodeName().equals("url")));
                                        boolean enabled0 = true;
                                        for (Element releases : NMavenSettingsLoaderBoot.elements(profile, x -> x.getNodeName().equals("releases"))) {
                                            for (Element enabled : NMavenSettingsLoaderBoot.elements(releases, x -> x.getNodeName().equals("enabled"))) {
                                                enabled0 = NMavenSettingsLoaderBoot.elementBoolean(enabled, enabled0);
                                            }
                                        }
                                        if (!enabled0 || NBootUtils.isBlank(id) || NBootUtils.isBlank(url0)) continue;
                                        list.add(NBootRepositoryLocation.of(id.trim(), "maven", url0.trim()));
                                    }
                                }
                            }
                            break;
                        }
                    }
                }
            }
            catch (Exception ex) {
                this.getLog().with().level(Level.FINE).verbFail().error(ex).log(NBootMsg.ofC("unable to load maven settings.xml %s", settingsFilePath));
            }
        }
        if (NBootUtils.isBlank(settings.getLocalRepository())) {
            settings.setLocalRepository(System.getProperty("user.home") + NBootUtils.getNativePath("/.m2/repository"));
        }
        if (NBootUtils.isBlank(settings.getRemoteRepository())) {
            settings.setRemoteRepository("https://repo.maven.apache.org/maven2");
        }
        settings.setActiveRepositories(list);
        return settings;
    }
}

