/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.thevpc.nuts.boot.NBootException;
import net.thevpc.nuts.boot.internal.util.NBootMsg;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootHomeLocation {
    private static final Map<String, NBootHomeLocation> CACHE = new HashMap<String, NBootHomeLocation>();
    private final String osFamily;
    private final String storeLocation;

    private NBootHomeLocation(String osFamily, String storeLocation) {
        this.osFamily = osFamily;
        this.storeLocation = storeLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NBootHomeLocation of(String osFamily, String storeLocation) {
        String key = NBootUtils.enumId(osFamily == null ? "system" : osFamily) + "_" + NBootUtils.enumId(storeLocation == null ? "system" : storeLocation);
        NBootHomeLocation instance = CACHE.get(key);
        if (instance == null) {
            Map<String, NBootHomeLocation> map = CACHE;
            synchronized (map) {
                instance = CACHE.get(key);
                if (instance == null) {
                    instance = new NBootHomeLocation(osFamily == null ? null : NBootUtils.enumName(osFamily), storeLocation == null ? null : NBootUtils.enumName(storeLocation));
                    CACHE.put(key, instance);
                }
            }
        }
        return instance;
    }

    public static NBootHomeLocation parse(String value) {
        if ((value = value == null ? "" : value.trim().toLowerCase()).isEmpty()) {
            return null;
        }
        String e = value.replace(':', '_').replace('-', '_');
        String finalValue = value;
        int i = e.lastIndexOf(95);
        if (i >= 0) {
            String loc;
            String s1 = e.substring(0, i);
            String s2 = e.substring(i + 1);
            String osf = s1.equals("system") ? null : s1;
            String string = loc = s2.equals("system") ? null : s2;
            if (osf == null && !s1.equals("system") && s1.length() > 0) {
                throw new NBootException(NBootMsg.ofC(NBootHomeLocation.class.getSimpleName() + " invalid value : %s", finalValue));
            }
            if (loc == null && !s2.equals("system") && s2.length() > 0) {
                throw new NBootException(NBootMsg.ofC(NBootHomeLocation.class.getSimpleName() + " invalid value : %s", finalValue));
            }
            return NBootHomeLocation.of(osf, loc);
        }
        throw new IllegalArgumentException(NBootMsg.ofC(NBootHomeLocation.class.getSimpleName() + " invalid value : %s", finalValue).toString());
    }

    public String getOsFamily() {
        return this.osFamily;
    }

    public String getStoreLocation() {
        return this.storeLocation;
    }

    public int hashCode() {
        return Objects.hash(this.osFamily, this.storeLocation);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBootHomeLocation that = (NBootHomeLocation)o;
        return Objects.equals(this.osFamily, that.osFamily) && Objects.equals(this.storeLocation, that.storeLocation);
    }

    public String toString() {
        return this.name();
    }

    public String name() {
        return ((this.osFamily == null ? "SYSTEM" : NBootUtils.enumName(this.osFamily)) + "_" + (this.storeLocation == null ? "SYSTEM" : NBootUtils.enumName(this.storeLocation))).toUpperCase();
    }

    public String id() {
        return (this.osFamily == null ? "system" : NBootUtils.enumId(this.osFamily)) + "-" + (this.storeLocation == null ? "system" : NBootUtils.enumId(this.storeLocation));
    }
}

