/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.thevpc.nuts.boot.NBootEnvCondition;
import net.thevpc.nuts.boot.NBootId;
import net.thevpc.nuts.boot.internal.util.NBootStringMapFormat;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootDependency {
    private static NBootStringMapFormat COMMA_MAP = NBootStringMapFormat.COMMA_FORMAT.copy(null, null, "&", null);
    private String repository;
    private String groupId;
    private String artifactId;
    private String version;
    private String scope;
    private String optional;
    private String type;
    private NBootEnvCondition condition = new NBootEnvCondition();
    private String classifier;
    private List<NBootId> exclusions = new ArrayList<NBootId>();
    private Map<String, String> properties = new LinkedHashMap<String, String>();

    public NBootDependency() {
    }

    public NBootDependency(String groupId, String artifactId) {
        this.groupId = NBootUtils.trimToNull(groupId);
        this.artifactId = NBootUtils.trimToNull(artifactId);
    }

    public NBootDependency(String repository, String groupId, String artifactId, String classifier, String version, String scope, String optional, List<NBootId> exclusions, NBootEnvCondition condition, String type, String properties) {
        this.repository = NBootUtils.trimToNull(repository);
        this.groupId = NBootUtils.trimToNull(groupId);
        this.artifactId = NBootUtils.trimToNull(artifactId);
        this.version = version == null ? "" : version;
        this.classifier = NBootUtils.trimToNull(classifier);
        this.scope = NBootUtils.firstNonNull(scope, "API");
        String o = NBootUtils.trimToNull(optional);
        if ("false".equalsIgnoreCase(o)) {
            o = null;
        } else if ("true".equalsIgnoreCase(o)) {
            o = "true";
        }
        this.optional = o;
        this.exclusions = NBootUtils.unmodifiableList(exclusions);
        for (NBootId exclusion : this.exclusions) {
            if (exclusion != null) continue;
            throw new NullPointerException();
        }
        this.condition = condition == null ? NBootEnvCondition.BLANK : condition;
        this.type = NBootUtils.trimToNull(type);
        this.properties = NBootStringMapFormat.DEFAULT.parse(properties);
    }

    public NBootDependency setId(NBootId id) {
        if (id == null) {
            this.setRepository(null);
            this.setGroupId(null);
            this.setArtifactId(null);
            this.setVersion(null);
        } else {
            this.setRepository(id.getRepository());
            this.setGroupId(id.getGroupId());
            this.setArtifactId(id.getArtifactId());
            this.setVersion(id.getVersion());
            this.setProperties(id.getProperties());
        }
        return this;
    }

    public NBootDependency setDependency(NBootDependency value) {
        return this.copyFrom(value);
    }

    public NBootDependency copyFrom(NBootDependency value) {
        if (value != null) {
            this.setRepository(value.getRepository());
            this.setGroupId(value.getGroupId());
            this.setArtifactId(value.getArtifactId());
            this.setVersion(value.getVersion());
            this.setScope(value.getScope());
            this.setOptional(value.getOptional());
            this.setExclusions(value.getExclusions());
            this.setClassifier(value.getClassifier());
            this.getCondition().clear().copyFrom(value.getCondition());
            this.setType(value.getType());
            this.setProperties(value.getProperties());
        } else {
            this.clear();
        }
        return this;
    }

    public NBootDependency clear() {
        this.setRepository(null);
        this.setGroupId(null);
        this.setArtifactId(null);
        this.setVersion(null);
        this.setScope(null);
        this.setOptional(null);
        this.setExclusions((List<NBootId>)null);
        this.setClassifier(null);
        this.getCondition().clear();
        this.setType(null);
        this.setProperties(null);
        return this;
    }

    public boolean isOptional() {
        return this.optional != null && Boolean.parseBoolean(this.optional);
    }

    public String getType() {
        return this.type;
    }

    public NBootDependency setType(String type) {
        this.type = NBootUtils.trimToNull(type);
        return this;
    }

    public String getOptional() {
        return this.optional;
    }

    public NBootDependency setOptional(String optional) {
        String o = NBootUtils.trimToNull(optional);
        if ("false".equals(o)) {
            o = null;
        } else if ("true".equalsIgnoreCase(o)) {
            o = "true";
        }
        this.optional = o;
        return this;
    }

    public String getScope() {
        return this.scope;
    }

    public NBootDependency setScope(String scope) {
        this.scope = scope == null ? "" : scope;
        return this;
    }

    public NBootId toId() {
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        if (!NBootUtils.isDependencyDefaultScope(this.scope)) {
            m.put("scope", this.scope);
        }
        if (!NBootUtils.isBlank(this.optional) && !"false".equals(this.optional)) {
            m.put("optional", this.optional);
        }
        if (!NBootUtils.isBlank(this.type)) {
            m.put("type", this.type);
        }
        if (this.exclusions.size() > 0) {
            m.put("exclusions", NBootUtils.toDependencyExclusionListString(this.exclusions));
        }
        return new NBootId().setRepository(this.getRepository()).setGroupId(this.getGroupId()).setArtifactId(this.getArtifactId()).setClassifier(this.getClassifier()).setVersion(this.getVersion()).setCondition(this.getCondition()).setProperties(m);
    }

    public String getRepository() {
        return this.repository;
    }

    public NBootDependency setRepository(String repository) {
        this.repository = NBootUtils.trimToNull(repository);
        return this;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public NBootDependency setGroupId(String groupId) {
        this.groupId = NBootUtils.trimToNull(groupId);
        return this;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public NBootDependency setArtifactId(String artifactId) {
        this.artifactId = NBootUtils.trimToNull(artifactId);
        return this;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public NBootDependency setClassifier(String classifier) {
        this.classifier = NBootUtils.trimToNull(classifier);
        return this;
    }

    public String getFullName() {
        if (NBootUtils.isBlank(this.groupId)) {
            return NBootUtils.trim(this.artifactId);
        }
        return NBootUtils.trim(this.groupId) + ":" + NBootUtils.trim(this.artifactId);
    }

    public String getVersion() {
        return this.version;
    }

    public NBootDependency setVersion(String version) {
        this.version = version == null ? "" : version;
        return this;
    }

    public List<NBootId> getExclusions() {
        return this.exclusions;
    }

    public NBootDependency setExclusions(List<NBootId> exclusions) {
        this.exclusions = NBootUtils.nonNullList(exclusions);
        return this;
    }

    public NBootDependency copy() {
        return new NBootDependency(this.getRepository(), this.getGroupId(), this.getArtifactId(), this.getClassifier(), this.getVersion(), this.getScope(), this.getOptional(), this.getExclusions(), this.getCondition(), this.getType(), this.getPropertiesQuery());
    }

    public NBootDependency setProperty(String property, String value) {
        if (property != null) {
            switch (property) {
                case "scope": {
                    this.setScope(value);
                    break;
                }
                case "version": {
                    this.setVersion(value);
                    break;
                }
                case "optional": {
                    this.setOptional(value);
                    break;
                }
                case "repo": {
                    this.setRepository(value);
                    break;
                }
                case "exclusions": {
                    this.setExclusions(value);
                    break;
                }
                case "os": {
                    this.condition.setOs(NBootUtils.parsePropertyIdList(value));
                    break;
                }
                case "arch": {
                    this.condition.setArch(NBootUtils.parsePropertyIdList(value));
                    break;
                }
                case "platform": {
                    this.condition.setPlatform(NBootUtils.parsePropertyIdList(value));
                    break;
                }
                case "osdist": {
                    this.condition.setOsDist(NBootUtils.parsePropertyIdList(value));
                    break;
                }
                case "desktop": {
                    this.condition.setDesktopEnvironment(NBootUtils.parsePropertyIdList(value));
                    break;
                }
                case "type": {
                    this.setType(value);
                    break;
                }
                default: {
                    if (value == null) {
                        this.properties.remove(property);
                        break;
                    }
                    this.properties.put(property, value);
                }
            }
        }
        return this;
    }

    public NBootDependency addPropertiesQuery(String propertiesQuery) {
        return this.addProperties(NBootStringMapFormat.DEFAULT.parse(propertiesQuery));
    }

    public NBootDependency addProperties(Map<String, String> queryMap) {
        if (queryMap != null) {
            for (Map.Entry<String, String> e : queryMap.entrySet()) {
                this.setProperty(e.getKey(), e.getValue());
            }
        }
        return this;
    }

    public NBootDependency setProperties(Map<String, String> queryMap) {
        this.properties.clear();
        if (queryMap != null) {
            for (Map.Entry<String, String> e : queryMap.entrySet()) {
                this.setProperty(e.getKey(), e.getValue());
            }
        }
        return this;
    }

    public NBootDependency setPropertiesQuery(String propertiesQuery) {
        this.setProperties(NBootStringMapFormat.DEFAULT.parse(propertiesQuery));
        return this;
    }

    public String getPropertiesQuery() {
        return NBootStringMapFormat.DEFAULT.format(this.properties);
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public NBootEnvCondition getCondition() {
        return this.condition;
    }

    public NBootDependency setCondition(NBootEnvCondition condition) {
        this.condition.clear().copyFrom(condition);
        return this;
    }

    public NBootDependency setExclusions(String exclusions) {
        if (exclusions == null) {
            exclusions = "";
        }
        ArrayList<NBootId> ids = new ArrayList<NBootId>();
        for (String s : NBootUtils.splitDefault(exclusions)) {
            NBootId ii = NBootId.of(s);
            if (ii == null) continue;
            ids.add(ii);
        }
        this.setExclusions(ids);
        return this;
    }

    public String toString() {
        return this.toId().toString();
    }

    public String getSimpleName() {
        return NBootUtils.getIdShortName(this.groupId, this.artifactId);
    }

    public String getLongName() {
        return NBootUtils.getIdLongName(this.groupId, this.artifactId, this.version, this.classifier);
    }

    public boolean isBlank() {
        return this.toString().isEmpty();
    }
}

