/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.boot;

import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import net.thevpc.nuts.boot.internal.util.NBootUtils;

public class NBootClassLoaderNode {
    private final String id;
    private final boolean includedInClasspath;
    private final URL url;
    private final boolean enabled;
    private final List<NBootClassLoaderNode> dependencies;

    public NBootClassLoaderNode(String id, URL url, boolean enabled, boolean includedInClasspath, NBootClassLoaderNode ... dependencies) {
        this.id = id;
        this.url = url;
        this.enabled = enabled;
        this.includedInClasspath = includedInClasspath;
        this.dependencies = NBootUtils.nonNullList(Arrays.asList(dependencies));
    }

    public boolean isIncludedInClasspath() {
        return this.includedInClasspath;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getId() {
        return this.id;
    }

    public URL getURL() {
        return this.url;
    }

    public List<NBootClassLoaderNode> getDependencies() {
        return this.dependencies;
    }

    public int hashCode() {
        int result = Objects.hash(this.id, this.includedInClasspath, this.url, this.enabled, this.dependencies);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NBootClassLoaderNode that = (NBootClassLoaderNode)o;
        return this.includedInClasspath == that.includedInClasspath && this.enabled == that.enabled && Objects.equals(this.id, that.id) && Objects.equals(this.url, that.url) && Objects.equals(this.dependencies, that.dependencies);
    }

    public String toString() {
        return "NutsClassLoaderNode{id='" + this.id + '\'' + ", loaded=" + this.includedInClasspath + ", url=" + this.url + ", enabled=" + this.enabled + ", dependencies=" + this.dependencies + '}';
    }
}

