/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.artifact;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import net.thevpc.nuts.artifact.DefaultNId;
import net.thevpc.nuts.artifact.NDependency;
import net.thevpc.nuts.artifact.NEnvCondition;
import net.thevpc.nuts.artifact.NIdBuilder;
import net.thevpc.nuts.artifact.NIdFilter;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.internal.NReservedUtils;
import net.thevpc.nuts.io.NLibPaths;
import net.thevpc.nuts.io.NPath;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;

public interface NId
extends Comparable<NId>,
NBlankable {
    public static final NId API_ID = NId.get("net.thevpc.nuts", "nuts", "").get();
    public static final NId RUNTIME_ID = NId.get("net.thevpc.nuts", "nuts-runtime", "").get();
    public static final Pattern PATTERN = Pattern.compile("^((?<group>[a-zA-Z0-9_.${}*-]*):)?(?<artifact>[a-zA-Z0-9_.${}*-]*)(:(?<classifier>[a-zA-Z0-9_.${}*-]*))?(#(?<version>[^?]+))?(\\?(?<query>.+))?$");
    public static final Pattern GROUP_ID_PATTERN = Pattern.compile("^[A-Za-z][A-Za-z0-9_]*(?:\\.[A-Za-z][A-Za-z0-9_]*)*$");
    public static final Pattern ARTIFACT_ID_PATTERN = Pattern.compile("^[A-Za-z0-9]+(?:[._-][A-Za-z0-9]+)*$");
    public static final NId BLANK = new DefaultNId();

    public static NOptional<List<NId>> getList(String value) {
        return NReservedUtils.parseIdList(value);
    }

    public static NOptional<Set<NId>> getSet(String value) {
        return NId.getList(value).map(LinkedHashSet::new);
    }

    public static NOptional<NId> get(String groupId, String artifactId) {
        return NOptional.of(new DefaultNId(groupId, artifactId, null));
    }

    public static NOptional<NId> get(String groupId, String artifactId, NVersion version) {
        return NOptional.of(new DefaultNId(groupId, artifactId, version));
    }

    public static NOptional<NId> get(String groupId, String artifactId, String version) {
        return NVersion.get(version).map(x -> new DefaultNId(groupId, artifactId, (NVersion)x));
    }

    public static NOptional<NId> getApi(NVersion version) {
        if (NBlankable.isBlank(version)) {
            return NOptional.of(API_ID);
        }
        return NId.get("net.thevpc.nuts", "nuts", version);
    }

    public static NOptional<NId> getRuntime(NVersion version) {
        if (NBlankable.isBlank(version)) {
            return NOptional.of(RUNTIME_ID);
        }
        return NId.get("net.thevpc.nuts", "net.thevpc.nuts:nuts-runtime", version);
    }

    public static NOptional<NId> getApi(String version) {
        if (NBlankable.isBlank(version)) {
            return NOptional.of(API_ID);
        }
        return NId.get("net.thevpc.nuts", "nuts", version);
    }

    public static NOptional<NId> getRuntime(String version) {
        if (NBlankable.isBlank(version)) {
            return NOptional.of(RUNTIME_ID);
        }
        return NId.get("net.thevpc.nuts", "nuts-runtime", version);
    }

    public static NOptional<NId> get(String value) {
        return NReservedUtils.parseId(value);
    }

    public static NOptional<NId> getForClass(Class<?> value) {
        return NLibPaths.of().resolveId(value);
    }

    public static NOptional<NId> getForPath(NPath value) {
        return NLibPaths.of().resolveId(value);
    }

    public static List<NId> ofList(String value) {
        return NId.getList(value).get();
    }

    public static Set<NId> ofSet(String value) {
        return NId.getSet(value).get();
    }

    public static NId of(String groupId, String artifactId) {
        return NId.get(groupId, artifactId).get();
    }

    public static NId of(String groupId, String artifactId, NVersion version) {
        return NId.get(groupId, artifactId, version).get();
    }

    public static NId of(String groupId, String artifactId, String version) {
        return NId.get(groupId, artifactId, version).get();
    }

    public static NId ofApi(NVersion version) {
        return NId.getApi(version).get();
    }

    public static NId ofRuntime(NVersion version) {
        return NId.getRuntime(version).get();
    }

    public static NId ofApi(String version) {
        return NId.getApi(version).get();
    }

    public static NId ofRuntime(String version) {
        return NId.getRuntime(version).get();
    }

    public static NId of(String value) {
        return NId.get(value).get();
    }

    public static NId ofClass(Class<?> value) {
        return NId.getForClass(value).get();
    }

    public static NId ofPath(NPath value) {
        return NId.getForPath(value).get();
    }

    public static List<NId> findAllByClass(Class<?> value) {
        return NLibPaths.of().resolveIds(value);
    }

    public static List<NId> findByPath(NPath value) {
        return NLibPaths.of().resolveIds(value);
    }

    public boolean equalsShortId(NId var1);

    public boolean equalsLongId(NId var1);

    public boolean isLongId();

    public boolean isShortId();

    public String getFace();

    public NEnvCondition getCondition();

    public String getPropertiesQuery();

    public Map<String, String> getProperties();

    public String getRepository();

    public String getGroupId();

    public String getFullName();

    public String getLongName();

    public String getShortName();

    public NId getShortId();

    public NId getLongId();

    public String getArtifactId();

    public String getClassifier();

    public String getPackaging();

    public NVersion getVersion();

    public NIdBuilder builder();

    public NDependency toDependency();

    public NIdFilter filter();

    public NId compatNewer();

    public NId compatOlder();

    public boolean isNull();

    @Override
    public boolean isBlank();

    public String getMavenFolder();

    public String getMavenFileName(String var1);

    public String getMavenPath(String var1);
}

