/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.artifact;

import net.thevpc.nuts.util.NEnum;
import net.thevpc.nuts.util.NEnumUtils;
import net.thevpc.nuts.util.NNameFormat;
import net.thevpc.nuts.util.NOptional;

public enum NDependencyScope implements NEnum
{
    API,
    IMPLEMENTATION,
    PROVIDED,
    IMPORT,
    RUNTIME,
    SYSTEM,
    TEST_API,
    TEST_IMPLEMENTATION,
    TEST_PROVIDED,
    TEST_RUNTIME,
    TEST_SYSTEM,
    OTHER,
    TEST_OTHER;

    private final String id = NNameFormat.ID_NAME.format(this.name());
    private final boolean api = this.id.equals("api") || this.id.equals("test");
    private final boolean implementation = this.id.equals("implementation") || this.id.endsWith("-implementation");
    private final boolean test;
    private final boolean system;
    private final boolean runtime;
    private final boolean provided = this.id.equals("provided") || this.id.endsWith("-provided");
    private final boolean other;

    private NDependencyScope() {
        this.runtime = this.id.equals("provided") || this.id.endsWith("-runtime");
        this.system = this.id.equals("system") || this.id.endsWith("-system");
        this.test = this.id.startsWith("test-");
        this.other = this.id.equals("other") || this.id.startsWith("other-");
    }

    public static NOptional<NDependencyScope> parse(String value) {
        return NEnumUtils.parseEnum(value, NDependencyScope.class, s -> {
            switch (s.getNormalizedValue()) {
                case "COMPILEONLY": 
                case "COMPILE_ONLY": 
                case "PROVIDED": {
                    return NOptional.of(PROVIDED);
                }
                case "TEST": 
                case "TESTCOMPILE": 
                case "TEST_COMPILE": 
                case "TESTAPI": 
                case "TEST_API": {
                    return NOptional.of(TEST_API);
                }
                case "TESTRUNTIME": 
                case "TEST_RUNTIME": {
                    return NOptional.of(TEST_RUNTIME);
                }
                case "TESTSYSTEM": 
                case "TEST_SYSTEM": {
                    return NOptional.of(TEST_SYSTEM);
                }
                case "TESTPROVIDED": 
                case "TEST_PROVIDED": 
                case "TESTCOMPILEONLY": 
                case "TEST_COMPILE_ONLY": {
                    return NOptional.of(TEST_PROVIDED);
                }
                case "API": 
                case "COMPILE": {
                    return NOptional.of(API);
                }
                case "IMPL": 
                case "IMPLEMENTATION": {
                    return NOptional.of(IMPLEMENTATION);
                }
                case "IMPORT": {
                    return NOptional.of(IMPORT);
                }
                case "RUNTIME": {
                    return NOptional.of(RUNTIME);
                }
                case "TEST_IMPL": 
                case "TEST_IMPLEMENTATION": {
                    return NOptional.of(TEST_IMPLEMENTATION);
                }
                case "TEST_OTHER": {
                    return NOptional.of(TEST_OTHER);
                }
                case "OTHER": {
                    return NOptional.of(OTHER);
                }
                case "SYSTEM": {
                    return NOptional.of(SYSTEM);
                }
            }
            return null;
        });
    }

    public boolean isCompile() {
        return !this.test;
    }

    public boolean isApi() {
        return this.api;
    }

    public boolean isImplementation() {
        return this.implementation;
    }

    public boolean isTest() {
        return this.test;
    }

    public boolean isSystem() {
        return this.system;
    }

    public boolean isRuntime() {
        return this.runtime;
    }

    public boolean isProvided() {
        return this.provided;
    }

    public boolean isOther() {
        return this.other;
    }

    @Override
    public String id() {
        return this.id;
    }
}

