/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.artifact;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NException;

public class NArtifactNotFoundException
extends NException {
    private final NId id;
    private Set<NIdInvalidLocation> locations = Collections.emptySet();
    private Set<NIdInvalidDependency> missingDependencies = Collections.emptySet();

    public NArtifactNotFoundException(NId id) {
        this(id, (NMsg)null);
    }

    public NArtifactNotFoundException(NId id, Throwable cause) {
        this(id, null, null, cause);
    }

    public NArtifactNotFoundException(NId id, NIdInvalidDependency[] dependencies, NIdInvalidLocation[] locations, Throwable cause) {
        super(NMsg.ofC("artifact not found: %s%s", id == null ? "<null>" : id, NArtifactNotFoundException.dependenciesToString(dependencies)), cause);
        this.id = id;
        if (locations != null) {
            this.locations = Collections.unmodifiableSet(Arrays.stream(locations).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
        if (dependencies != null) {
            this.missingDependencies = Collections.unmodifiableSet(Arrays.stream(dependencies).filter(Objects::nonNull).collect(Collectors.toSet()));
        }
    }

    public NArtifactNotFoundException(NId id, NMsg message, Throwable cause) {
        super(message == null ? NMsg.ofC("no such nuts : %s", id == null ? "<null>" : id) : message, cause);
        this.id = id;
    }

    public NArtifactNotFoundException(NId id, NMsg message) {
        this(id, message, null);
    }

    protected static String dependenciesToString(NIdInvalidDependency[] dependencies) {
        Set<NIdInvalidDependency> missingDependencies0;
        Set<NIdInvalidDependency> set = missingDependencies0 = dependencies == null ? Collections.emptySet() : Collections.unmodifiableSet(Arrays.stream(dependencies).filter(Objects::nonNull).collect(Collectors.toSet()));
        if (missingDependencies0.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(" : missing dependencies :");
        for (NIdInvalidDependency d2 : missingDependencies0) {
            sb.append("\n").append(NArtifactNotFoundException.dependenciesToString("  ", d2));
        }
        return sb.toString();
    }

    protected static String dependenciesToString(String prefix, NIdInvalidDependency d) {
        StringBuilder sb = new StringBuilder();
        sb.append(prefix).append(d.id);
        for (NIdInvalidDependency d2 : d.getCause()) {
            sb.append("\n").append(NArtifactNotFoundException.dependenciesToString(prefix + "  ", d2));
        }
        return sb.toString();
    }

    public NIdInvalidDependency toInvalidDependency() {
        return new NIdInvalidDependency(this.getId(), this.getMissingDependencies());
    }

    public NId getId() {
        return this.id;
    }

    public Set<NIdInvalidDependency> getMissingDependencies() {
        return this.missingDependencies;
    }

    public Set<NIdInvalidLocation> getLocations() {
        return this.locations;
    }

    public static class NIdInvalidDependency
    implements Serializable {
        private final NId id;
        private final Set<NIdInvalidDependency> cause;

        public NIdInvalidDependency(NId id, Set<NIdInvalidDependency> cause) {
            this.id = id;
            this.cause = cause == null ? Collections.emptySet() : cause;
        }

        public NId getId() {
            return this.id;
        }

        public Set<NIdInvalidDependency> getCause() {
            return this.cause;
        }

        public int hashCode() {
            return Objects.hash(this.id, this.cause);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NIdInvalidDependency that = (NIdInvalidDependency)o;
            return Objects.equals(this.id, that.id) && Objects.equals(this.cause, that.cause);
        }
    }

    public static class NIdInvalidLocation
    implements Serializable {
        private final String repository;
        private final String url;
        private final String message;

        public NIdInvalidLocation(String repository, String url, String message) {
            this.repository = repository;
            this.url = url;
            this.message = message;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getUrl() {
            return this.url;
        }

        public String getMessage() {
            return this.message;
        }

        public int hashCode() {
            return Objects.hash(this.repository, this.url, this.message);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NIdInvalidLocation that = (NIdInvalidLocation)o;
            return Objects.equals(this.repository, that.repository) && Objects.equals(this.url, that.url) && Objects.equals(this.message, that.message);
        }
    }
}

