/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.artifact;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Pattern;
import net.thevpc.nuts.artifact.DefaultNVersionPart;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.artifact.NVersionComparator;
import net.thevpc.nuts.artifact.NVersionFilter;
import net.thevpc.nuts.artifact.NVersionFilters;
import net.thevpc.nuts.artifact.NVersionInterval;
import net.thevpc.nuts.artifact.NVersionPart;
import net.thevpc.nuts.artifact.NVersionPartType;
import net.thevpc.nuts.text.NI18n;
import net.thevpc.nuts.text.NMsg;
import net.thevpc.nuts.util.NLiteral;
import net.thevpc.nuts.util.NOptional;
import net.thevpc.nuts.util.NStringUtils;

public class DefaultNVersion
implements NVersion {
    private static Pattern VERSION_PART_PATTERN = Pattern.compile("([0-9a-zA-Z_.-])+");
    private static final long serialVersionUID = 1L;
    protected String expression;
    private VersionParts parts;

    public DefaultNVersion(String expression) {
        this.expression = NStringUtils.trim(expression);
    }

    public static String incVersion(String oldVersion, int level, long count) {
        return DefaultNVersion.incVersion(oldVersion, level, BigInteger.valueOf(count));
    }

    public static String incVersion(String oldVersion, int level, BigInteger count) {
        VersionParts parts;
        int digitCount;
        if (count == null) {
            count = BigInteger.ZERO;
        }
        if ((digitCount = (parts = DefaultNVersion.splitVersionParts2(oldVersion)).getNumbersCount()) == 0) {
            parts.addNumber(BigInteger.ZERO, ".");
            digitCount = parts.getNumbersCount();
        }
        if (level < 0) {
            for (level = digitCount + level; level < 0; ++level) {
                parts.addNumber(BigInteger.ZERO, ".");
            }
            NVersionPart digit = parts.getNumberAt(level);
            parts.setNumberAt(level, new BigInteger(digit.value()).add(count));
            return parts.toString();
        }
        for (int i = digitCount; i < level; ++i) {
            parts.addNumber(BigInteger.ZERO, ".");
        }
        NVersionPart digit = parts.getNumberAt(level);
        parts.setNumberAt(level, new BigInteger(digit.value()).add(count));
        return parts.toString();
    }

    @Override
    public List<NVersionPart> parts() {
        return new ArrayList<NVersionPart>(DefaultNVersion.splitVersionParts2((String)NStringUtils.trim((String)this.expression)).all);
    }

    private static VersionParts splitVersionParts2(String v1) {
        v1 = NStringUtils.trim(v1);
        ArrayList<NVersionPart> parts = new ArrayList<NVersionPart>();
        StringBuilder last = null;
        NVersionPartType partType = null;
        boolean qualVisited = false;
        boolean numberVisited = false;
        for (char c : v1.toCharArray()) {
            if (Character.isDigit(c)) {
                numberVisited = true;
                if (last == null) {
                    last = new StringBuilder();
                    last.append(c);
                    partType = NVersionPartType.NUMBER;
                    continue;
                }
                if (partType == NVersionPartType.NUMBER) {
                    last.append(c);
                    continue;
                }
                parts.add(new DefaultNVersionPart(last.toString(), partType));
                last.delete(0, last.length());
                partType = NVersionPartType.NUMBER;
                last.append(c);
                continue;
            }
            if (c == '.' || c == '-') {
                if (last != null) {
                    parts.add(new DefaultNVersionPart(last.toString(), partType));
                    last = null;
                }
                parts.add(new DefaultNVersionPart(String.valueOf(c), NVersionPartType.SEPARATOR));
                partType = NVersionPartType.SEPARATOR;
                continue;
            }
            if (last == null) {
                if (numberVisited) {
                    if (qualVisited) {
                        partType = NVersionPartType.SUFFIX;
                    } else {
                        partType = NVersionPartType.QUALIFIER;
                        qualVisited = true;
                    }
                } else {
                    partType = NVersionPartType.PREFIX;
                }
                last = new StringBuilder();
                last.append(c);
                continue;
            }
            if (partType == NVersionPartType.QUALIFIER || partType == NVersionPartType.PREFIX || partType == NVersionPartType.SUFFIX) {
                last.append(c);
                continue;
            }
            parts.add(new DefaultNVersionPart(last.toString(), partType));
            if (numberVisited) {
                if (qualVisited) {
                    partType = NVersionPartType.SUFFIX;
                } else {
                    partType = NVersionPartType.QUALIFIER;
                    qualVisited = true;
                }
            } else {
                partType = NVersionPartType.PREFIX;
            }
            last.delete(0, last.length());
            last.append(c);
        }
        if (last != null && last.length() > 0) {
            parts.add(new DefaultNVersionPart(last.toString(), partType));
        }
        return new VersionParts(parts);
    }

    @Override
    public boolean isLatestVersion() {
        String s = this.asSingleValue().orNull();
        return "LATEST".equalsIgnoreCase(s);
    }

    @Override
    public boolean isReleaseVersion() {
        String s = this.asSingleValue().orNull();
        return "RELEASE".equalsIgnoreCase(s);
    }

    @Override
    public boolean isSnapshotVersion() {
        String s = this.asSingleValue().orNull();
        return s != null && s.toUpperCase().endsWith("-SNAPSHOT");
    }

    @Override
    public boolean isNull() {
        return this.expression == null;
    }

    @Override
    public boolean isBlank() {
        return this.expression == null || this.expression.trim().isEmpty();
    }

    @Override
    public String getValue() {
        return this.expression;
    }

    @Override
    public int compareTo(String other) {
        return this.compareTo(NVersion.of(other), null);
    }

    @Override
    public int compareTo(NVersion other) {
        return this.compareTo(other, null);
    }

    @Override
    public int compareTo(String other, NVersionComparator comparator) {
        return this.compareTo(other == null ? BLANK : NVersion.of(other), comparator);
    }

    @Override
    public int compareTo(NVersion other, NVersionComparator comparator) {
        return (comparator == null ? NVersionComparator.of() : comparator).compare(this, other);
    }

    @Override
    public NVersion toCanonical() {
        VersionParts parts = this.getParts();
        ArrayList<NVersionPart> can = new ArrayList<NVersionPart>();
        for (NVersionPart p : parts.all) {
            if (p.type() == NVersionPartType.NUMBER || p.type() == NVersionPartType.PREFIX || p.type() == NVersionPartType.SEPARATOR) {
                can.add(p);
                continue;
            }
            if (p.type() != NVersionPartType.QUALIFIER) continue;
            break;
        }
        while (!can.isEmpty() && ((NVersionPart)can.get(can.size() - 1)).type() == NVersionPartType.SEPARATOR) {
            can.remove(can.size() - 1);
        }
        StringBuilder sb = new StringBuilder();
        for (NVersionPart v : can) {
            sb.append(v.value());
        }
        return NVersion.of(sb.toString());
    }

    @Override
    public NVersion toNormalized() {
        ArrayList<NVersionPart> parts = new ArrayList<NVersionPart>(this.getParts().all);
        while (!parts.isEmpty()) {
            NVersionPart last = (NVersionPart)parts.get(parts.size() - 1);
            if (last.type() == NVersionPartType.SEPARATOR) {
                parts.remove(parts.size() - 1);
                continue;
            }
            if (last.type() != NVersionPartType.NUMBER || !new BigInteger(last.value()).equals(BigInteger.ZERO)) break;
            parts.remove(parts.size() - 1);
        }
        StringBuilder sb = new StringBuilder();
        for (NVersionPart v : parts) {
            sb.append(v.value());
        }
        return NVersion.of(sb.toString());
    }

    @Override
    public NVersionFilter filter() {
        return this.filter(null);
    }

    @Override
    public NVersionFilter filter(NVersionComparator comparator) {
        return NVersionFilters.of().byValue(this.expression, comparator).get();
    }

    @Override
    public NVersion compatNewer() {
        String v = this.toExplicitSingleValueOrNullString();
        if (v == null) {
            return this;
        }
        return new DefaultNVersion("[" + this.expression + ",[");
    }

    @Override
    public NVersion compatOlder() {
        String v = this.toExplicitSingleValueOrNullString();
        if (v == null) {
            return this;
        }
        return new DefaultNVersion("]," + v + "]");
    }

    @Override
    public NOptional<List<NVersionInterval>> intervals() {
        return this.intervals(null);
    }

    @Override
    public NOptional<List<NVersionInterval>> intervals(NVersionComparator comparator) {
        return NVersionInterval.ofList(this.expression, comparator);
    }

    @Override
    public NOptional<String> asSingleValue() {
        if (VERSION_PART_PATTERN.matcher(this.expression).matches()) {
            return NOptional.of(this.expression);
        }
        int commas = 0;
        int seps = 0;
        String s = this.expression.trim();
        NOptional<String> emptyVersion = NOptional.ofEmpty(() -> NMsg.ofC("not a single value : %s", this.expression));
        if (s.isEmpty()) {
            return emptyVersion;
        }
        block5: for (char c : s.toCharArray()) {
            switch (c) {
                case '*': {
                    return emptyVersion;
                }
                case ',': {
                    if (++commas > 1) {
                        return emptyVersion;
                    }
                    if (seps < 2) continue block5;
                    return emptyVersion;
                }
                case '(': 
                case ')': 
                case '[': 
                case ']': {
                    if (++seps <= 2) continue block5;
                    return emptyVersion;
                }
                default: {
                    if (Character.isWhitespace(c) || seps < 2) continue block5;
                    return emptyVersion;
                }
            }
        }
        if (seps == 0) {
            if (commas == 0) {
                if (VERSION_PART_PATTERN.matcher(this.expression).matches()) {
                    return NOptional.of(this.expression.trim());
                }
            } else {
                String one;
                HashSet<String> all = new HashSet<String>(NStringUtils.split(s, ",", true, true));
                if (all.size() == 1 && VERSION_PART_PATTERN.matcher(one = (String)all.stream().findAny().get()).matches()) {
                    return NOptional.of(one);
                }
            }
        } else if (seps == 2) {
            int o = s.charAt(0);
            int c = s.charAt(s.length() - 1);
            if (o == 40) {
                o = 93;
            }
            if (c == 41) {
                c = 91;
            }
            s = s.substring(1, s.length() - 1).trim();
            if (o == 91 && c == 93) {
                if (commas == 0) {
                    if (VERSION_PART_PATTERN.matcher(s).matches()) {
                        return NOptional.of(s);
                    }
                } else {
                    String one;
                    HashSet<String> two = new HashSet<String>(NStringUtils.split(s, ",", true, false));
                    if (two.size() == 1 && VERSION_PART_PATTERN.matcher(one = (String)two.stream().findAny().get()).matches()) {
                        return NOptional.of(one);
                    }
                }
            }
        }
        return emptyVersion;
    }

    @Override
    public boolean isSingleValue() {
        return this.asSingleValue().isPresent();
    }

    @Override
    public boolean isFilter() {
        for (char c : this.expression.toCharArray()) {
            switch (c) {
                case '(': 
                case ')': 
                case '*': 
                case ',': 
                case '[': 
                case ']': {
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public NVersion inc() {
        return this.inc(-1);
    }

    @Override
    public NVersion inc(int index) {
        return this.inc(index, 1L);
    }

    @Override
    public NVersion inc(int index, long amount) {
        return new DefaultNVersion(DefaultNVersion.incVersion(this.getValue(), index, amount));
    }

    @Override
    public NVersion inc(int index, BigInteger amount) {
        return new DefaultNVersion(DefaultNVersion.incVersion(this.getValue(), index, amount));
    }

    @Override
    public int size() {
        VersionParts parts = this.getParts();
        return parts.size();
    }

    @Override
    public int numberSize() {
        return this.getParts().getNumbersCount();
    }

    @Override
    public NLiteral[] split() {
        VersionParts parts = this.getParts();
        int size = parts.size();
        NLiteral[] all = new NLiteral[size];
        for (int i = 0; i < size; ++i) {
            all[i] = NLiteral.of(parts.get(i).value());
        }
        return all;
    }

    @Override
    public NOptional<NLiteral> get(int index) {
        VersionParts parts = this.getParts();
        int size = parts.size();
        if (index >= 0) {
            if (index < parts.size()) {
                return NOptional.of(NLiteral.of(parts.get(index).value()));
            }
        } else {
            int x = size + index;
            if (x >= 0 && x < parts.size()) {
                return NOptional.of(NLiteral.of(parts.get(x).value()));
            }
        }
        return NOptional.ofEmpty(() -> NMsg.ofC("version part not found : %s", index));
    }

    @Override
    public NOptional<NLiteral> getNumberLiteralAt(int level) {
        VersionParts parts = this.getParts();
        int size = parts.getNumbersCount();
        if (level >= 0) {
            NVersionPart digit = parts.getNumberAt(level);
            return NOptional.of(digit == null ? null : NLiteral.of(digit.value()), () -> NMsg.ofC("missing number at %s", level));
        }
        int x = size + level;
        NVersionPart digit = x >= 0 ? parts.getNumberAt(x) : null;
        return NOptional.of(digit == null ? null : NLiteral.of(digit.value()), () -> NMsg.ofC("missing number at %s", level));
    }

    @Override
    public NOptional<Integer> getIntegerAt(int index) {
        return this.getNumberLiteralAt(index).flatMap(NLiteral::asInt);
    }

    @Override
    public NOptional<Long> getLongAt(int index) {
        return this.getNumberLiteralAt(index).flatMap(NLiteral::asLong);
    }

    private String toExplicitSingleValueOrNullString() {
        if (!this.isBlank() && !this.isFilter()) {
            return this.expression;
        }
        return null;
    }

    private VersionParts getParts() {
        if (this.parts == null) {
            this.parts = DefaultNVersion.splitVersionParts2(this.getValue());
        }
        return this.parts;
    }

    public int hashCode() {
        return this.expression != null ? this.expression.hashCode() : 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNVersion version = (DefaultNVersion)o;
        return this.expression != null ? this.expression.equals(version.expression) : version.expression == null;
    }

    public String toString() {
        return this.expression == null ? "" : this.expression;
    }

    private static class VersionParts {
        List<NVersionPart> all;

        public VersionParts(List<NVersionPart> all) {
            this.all = all;
        }

        public NVersionPart get(int index) {
            return this.all.get(index);
        }

        public int size() {
            return this.all.size();
        }

        public int getNumbersCount() {
            int c = 0;
            for (NVersionPart s : this.all) {
                if (s.type() != NVersionPartType.NUMBER) continue;
                ++c;
            }
            return c;
        }

        public void setNumberAt(int index, BigInteger value) {
            int c = 0;
            for (int i = 0; i < this.all.size(); ++i) {
                NVersionPart s = this.all.get(i);
                if (s.type() != NVersionPartType.NUMBER) continue;
                if (c == index) {
                    this.all.set(i, new DefaultNVersionPart(value.toString(), NVersionPartType.NUMBER));
                    return;
                }
                ++c;
            }
        }

        public void setNumberAt(int index, long value) {
            int c = 0;
            for (int i = 0; i < this.all.size(); ++i) {
                NVersionPart s = this.all.get(i);
                if (s.type() != NVersionPartType.NUMBER) continue;
                if (c == index) {
                    this.all.set(i, new DefaultNVersionPart(String.valueOf(value), NVersionPartType.NUMBER));
                    return;
                }
                ++c;
            }
        }

        public NVersionPart getNumberAt(int index) {
            int c = 0;
            for (NVersionPart s : this.all) {
                if (s.type() != NVersionPartType.NUMBER) continue;
                if (c == index) {
                    return s;
                }
                ++c;
            }
            return null;
        }

        public void insertNumber(long val, String sep) {
            if (this.all.size() == 0) {
                this.all.add(new DefaultNVersionPart(String.valueOf(val), NVersionPartType.NUMBER));
            } else if (this.all.get(0).type() == NVersionPartType.NUMBER) {
                if (sep == null) {
                    sep = ".";
                }
                if (!sep.equals(".") && !sep.equals("-")) {
                    throw new IllegalArgumentException("illegal separator");
                }
                this.all.add(0, new DefaultNVersionPart(sep, NVersionPartType.SEPARATOR));
                this.all.add(0, new DefaultNVersionPart(String.valueOf(val), NVersionPartType.NUMBER));
            } else {
                this.all.add(0, new DefaultNVersionPart(String.valueOf(val), NVersionPartType.NUMBER));
            }
        }

        public void addNumber(BigInteger val, String sep) {
            if (this.all.size() == 0) {
                this.all.add(new DefaultNVersionPart(String.valueOf(val), NVersionPartType.NUMBER));
            } else if (this.all.get(this.all.size() - 1).type() == NVersionPartType.NUMBER) {
                if (sep == null) {
                    sep = ".";
                }
                if (!sep.equals(".") && !sep.equals("-")) {
                    throw new IllegalArgumentException(NMsg.ofC(NI18n.of("illegal version number separator %s"), sep).toString());
                }
                this.all.add(new DefaultNVersionPart(sep, NVersionPartType.SEPARATOR));
                this.all.add(new DefaultNVersionPart(String.valueOf(val), NVersionPartType.NUMBER));
            } else {
                this.all.add(new DefaultNVersionPart(String.valueOf(val), NVersionPartType.NUMBER));
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            for (NVersionPart versionPart : this.all) {
                sb.append(versionPart.value());
            }
            return sb.toString();
        }
    }
}

