/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts.artifact;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.thevpc.nuts.artifact.NEnvCondition;
import net.thevpc.nuts.artifact.NEnvConditionBuilder;
import net.thevpc.nuts.internal.NReservedUtils;
import net.thevpc.nuts.util.NBlankable;

public class DefaultNEnvCondition
implements NEnvCondition {
    private static final long serialVersionUID = 1L;
    private List<String> arch;
    private List<String> profiles;
    private List<String> os;
    private List<String> osDist;
    private List<String> platform;
    private List<String> desktopEnvironment;
    private Map<String, String> properties;

    public DefaultNEnvCondition(NEnvCondition d) {
        this(d.getArch(), d.getOs(), d.getOsDist(), d.getPlatform(), d.getDesktopEnvironment(), d.getProfiles(), d.getProperties());
    }

    public DefaultNEnvCondition() {
        this(null, null, null, null, null, null, null);
    }

    public DefaultNEnvCondition(List<String> arch, List<String> os, List<String> osDist, List<String> platform, List<String> desktopEnvironment, List<String> profiles, Map<String, String> properties) {
        this.arch = arch == null ? Collections.emptyList() : Collections.unmodifiableList(arch);
        this.os = os == null ? Collections.emptyList() : Collections.unmodifiableList(os);
        this.osDist = osDist == null ? Collections.emptyList() : Collections.unmodifiableList(osDist);
        this.platform = platform == null ? Collections.emptyList() : Collections.unmodifiableList(platform);
        this.desktopEnvironment = desktopEnvironment == null ? Collections.emptyList() : Collections.unmodifiableList(desktopEnvironment);
        this.profiles = profiles == null ? Collections.emptyList() : Collections.unmodifiableList(profiles);
        this.properties = properties == null ? new HashMap<String, String>() : new HashMap<String, String>(properties);
    }

    @Override
    public Map<String, String> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    @Override
    public boolean isBlank() {
        for (String s : this.arch) {
            if (NBlankable.isBlank(s)) continue;
            return false;
        }
        for (String s : this.os) {
            if (NBlankable.isBlank(s)) continue;
            return false;
        }
        for (String s : this.osDist) {
            if (NBlankable.isBlank(s)) continue;
            return false;
        }
        for (String s : this.platform) {
            if (NBlankable.isBlank(s)) continue;
            return false;
        }
        for (String s : this.desktopEnvironment) {
            if (NBlankable.isBlank(s)) continue;
            return false;
        }
        for (String s : this.profiles) {
            if (NBlankable.isBlank(s)) continue;
            return false;
        }
        return this.properties.isEmpty();
    }

    @Override
    public List<String> getProfiles() {
        return this.profiles;
    }

    @Override
    public List<String> getArch() {
        return this.arch;
    }

    @Override
    public List<String> getOs() {
        return this.os;
    }

    @Override
    public List<String> getOsDist() {
        return this.osDist;
    }

    @Override
    public List<String> getPlatform() {
        return this.platform;
    }

    @Override
    public List<String> getDesktopEnvironment() {
        return this.desktopEnvironment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultNEnvCondition that = (DefaultNEnvCondition)o;
        return Objects.equals(this.properties, that.properties) && Objects.equals(this.arch, that.arch) && Objects.equals(this.os, that.os) && Objects.equals(this.osDist, that.osDist) && Objects.equals(this.platform, that.platform) && Objects.equals(this.profiles, that.profiles) && Objects.equals(this.desktopEnvironment, that.desktopEnvironment);
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + Objects.hashCode(this.properties);
        result = 31 * result + Objects.hashCode(this.arch);
        result = 31 * result + Objects.hashCode(this.os);
        result = 31 * result + Objects.hashCode(this.osDist);
        result = 31 * result + Objects.hashCode(this.platform);
        result = 31 * result + Objects.hashCode(this.profiles);
        result = 31 * result + Objects.hashCode(this.desktopEnvironment);
        return result;
    }

    public String toString() {
        String s = String.join((CharSequence)" & ", (CharSequence[])Arrays.stream(new String[]{this.ts("profile", this.profiles), this.ts("arch", this.arch), this.ts("os", this.os), this.ts("osDist", this.osDist), this.ts("platform", this.platform), this.ts("desktop", this.desktopEnvironment), this.ts("props", this.properties)}).filter(x -> x.length() > 0).toArray(String[]::new));
        if (s.isEmpty()) {
            return "blank";
        }
        return s;
    }

    private String ts(String n, List<String> vs) {
        if (vs == null || vs.size() == 0) {
            return "";
        }
        return n + "=" + String.join((CharSequence)",", vs);
    }

    private String ts(String n, Map<String, String> properties) {
        if (properties.isEmpty()) {
            return "";
        }
        return n + "={" + properties.entrySet().stream().map(x -> {
            String k = (String)x.getKey();
            String v = (String)x.getValue();
            if (v == null) {
                return k;
            }
            return k + "=" + v;
        }).collect(Collectors.joining(",")) + "}";
    }

    @Override
    public NEnvConditionBuilder builder() {
        return NEnvConditionBuilder.of().copyFrom(this);
    }

    @Override
    public Map<String, String> toMap() {
        return NReservedUtils.toMap(this);
    }
}

