/*
 * Decompiled with CFR 0.152.
 */
package net.thevpc.nuts;

import java.util.ArrayList;
import net.thevpc.nuts.artifact.NId;
import net.thevpc.nuts.artifact.NVersion;
import net.thevpc.nuts.boot.NBootArguments;
import net.thevpc.nuts.boot.NBootUnsatisfiedRequirementsException;
import net.thevpc.nuts.boot.NBootWorkspace;
import net.thevpc.nuts.command.NExecutionException;
import net.thevpc.nuts.core.NWorkspace;
import net.thevpc.nuts.core.NWorkspaceOptions;
import net.thevpc.nuts.util.NBlankable;
import net.thevpc.nuts.util.NOptional;

public final class Nuts {
    private static final NVersion version = NVersion.of("0.8.9");
    private static final NVersion bootVersion = NVersion.of("0.8.9");
    private static final NId id = NId.of("net.thevpc.nuts", "nuts", version);
    private static volatile NWorkspace defaultInMemoryWorkspace;

    private Nuts() {
    }

    public static NVersion getVersion() {
        return version;
    }

    public static NVersion getBootVersion() {
        return bootVersion;
    }

    public static NId getApiId() {
        return id;
    }

    public static NWorkspace require() throws NBootUnsatisfiedRequirementsException {
        NOptional<NWorkspace> w = NWorkspace.get();
        if (w.isPresent()) {
            return w.get();
        }
        return Nuts.defaultWorkspace().share();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NWorkspace defaultWorkspace() throws NBootUnsatisfiedRequirementsException {
        NOptional<NWorkspace> w = NWorkspace.get();
        if (w.isPresent()) {
            return w.get();
        }
        if (defaultInMemoryWorkspace != null) return defaultInMemoryWorkspace;
        Class<Nuts> clazz = Nuts.class;
        synchronized (Nuts.class) {
            if (defaultInMemoryWorkspace != null) return defaultInMemoryWorkspace;
            defaultInMemoryWorkspace = Nuts.openWorkspace("--reset-options", "--in-memory");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return defaultInMemoryWorkspace;
        }
    }

    public static NWorkspace require(String ... options) throws NBootUnsatisfiedRequirementsException {
        NOptional<NWorkspace> w = NWorkspace.get();
        if (w.isPresent()) {
            return w.get();
        }
        ArrayList<String> newOptions = new ArrayList<String>();
        newOptions.add("--reset-options");
        if (options != null && options.length > 0) {
            for (String o : options) {
                if (NBlankable.isBlank(o)) continue;
                newOptions.add(o);
            }
        }
        newOptions.add("--in-memory");
        return Nuts.openWorkspace(newOptions.toArray(new String[0])).share();
    }

    public static NWorkspace openWorkspace(String ... args) throws NBootUnsatisfiedRequirementsException {
        return Nuts.openWorkspace(NBootArguments.of(args));
    }

    public static NWorkspace openWorkspace(NBootArguments args) throws NBootUnsatisfiedRequirementsException {
        return (NWorkspace)NBootWorkspace.of(args).getWorkspace();
    }

    public static NWorkspace openWorkspace() {
        return Nuts.openWorkspace((NBootArguments)null);
    }

    public static NWorkspace openWorkspace(NWorkspaceOptions options) {
        return (NWorkspace)NBootWorkspace.of(options == null ? null : options.toBootOptionsInfo()).getWorkspace();
    }

    public static NWorkspace runWorkspace(String ... args) throws NExecutionException {
        return Nuts.runWorkspace(NBootArguments.of(args));
    }

    public static NWorkspace runWorkspace(NWorkspaceOptions options) {
        return (NWorkspace)NBootWorkspace.of(options == null ? null : options.toBootOptionsInfo()).runWorkspace().getWorkspace();
    }

    public static NWorkspace runWorkspace(NBootArguments args) throws NExecutionException {
        return (NWorkspace)NBootWorkspace.of(args).runWorkspace().getWorkspace();
    }
}

